<?php

// 路由 - 只接受三個參數 0 => Http Method , 2 => 控制器@方法 , 3 => 中介層 (陣列 可多個)
// 路由路徑 - 帶入控制器方法的參數 請務必用 {} 包起來, 以搜尋 " /{ " 來判斷後面的全都是參數

return [
	// 登入/登出
	['admin'        => ['get', 'Admin\LoginController@index', ['admin.guest'] ] ],
	['admin'        => ['post', 'Admin\LoginController@login', ['admin.guest'] ] ],
	['admin/logout' => ['get', 'Admin\LoginController@logout'] ],

	// 首頁
	['admin/index' => ['get', 'Admin\IndexController@index', ['admin'] ] ],

	// 帳號管理
	['admin/account/upd_pw/{id}' => ['get', 'Admin\AccountController@show_upd_pw', ['admin'] ] ],
	['admin/account/upd_pw/{id}'  => ['patch', 'Admin\AccountController@upd_pw', ['admin'] ] ],

	// HTML 編輯器
	['admin/html-editor/manager'            => ['get', 'Admin\HtmlEditorManagerController@show', ['admin'] ] ],
	['admin/html-editor/manager/{class_id}' => ['get', 'Admin\HtmlEditorManagerController@show', ['admin'] ] ],
	['admin/html-editor/{class_id}/{id}'    => ['post', 'Admin\HtmlEditorManagerController@add', ['admin'] ] ],
	['admin/html-editor/{class_id}/{id}'    => ['patch', 'Admin\HtmlEditorManagerController@upd', ['admin'] ] ],
	['admin/html-editor/{class_id}/{id}'    => ['delete', 'Admin\HtmlEditorManagerController@del', ['admin'] ] ],
		# 上傳圖片
	['admin/html-editor/image-upload'       => ['post', 'Admin\HtmlEditorManagerController@single_image_upload', ['admin'] ] ],
		# 多圖
	['admin/html-editor/ajax/pics/{pid}' => ['get', 'Admin\HtmlEditorManagerController@ajax_pics_get'] ],
	['admin/html-editor/ajax/pics/{pid}' => ['post', 'Admin\HtmlEditorManagerController@ajax_pics_upload'] ],
	['admin/html-editor/ajax/pics/{pid}/{id}/{column}' => ['patch', 'Admin\HtmlEditorManagerController@ajax_pics_upd'] ],
	['admin/html-editor/ajax/pics/{pid}/{id}' => ['delete', 'Admin\HtmlEditorManagerController@ajax_pics_del'] ],

	// Page (開發用)
	['admin/page'      => ['get', 'Admin\PageController@index', ['admin'] ] ],
	['admin/page/{id}' => ['get', 'Admin\PageController@edit', ['admin'] ] ],
	['admin/page/{id}' => ['post', 'Admin\PageController@add', ['admin'] ] ],
	['admin/page/{id}' => ['patch', 'Admin\PageController@upd', ['admin'] ] ],
	['admin/page/{id}' => ['delete', 'Admin\PageController@del', ['admin'] ] ],
		# 多圖
	['admin/page/ajax/pics/{pid}' => ['get', 'Admin\PageController@ajax_pics_get'] ],
	['admin/page/ajax/pics/{pid}' => ['post', 'Admin\PageController@ajax_pics_upload'] ],
	['admin/page/ajax/pics/{pid}/{id}/{column}' => ['patch', 'Admin\PageController@ajax_pics_upd'] ],
	['admin/page/ajax/pics/{pid}/{id}' => ['delete', 'Admin\PageController@ajax_pics_del'] ],
		# 多檔
	['admin/page/ajax/files/{pid}' => ['get', 'Admin\PageController@ajax_files_get'] ],
	['admin/page/ajax/files/{pid}' => ['post', 'Admin\PageController@ajax_files_upload'] ],
	['admin/page/ajax/files/{pid}/{id}/{column}' => ['patch', 'Admin\PageController@ajax_files_upd'] ],
	['admin/page/ajax/files/{pid}/{id}' => ['delete', 'Admin\PageController@ajax_files_del'] ],

	// SEO
		# 分類
	['admin/seo_class/{class_id}'      => ['get', 'Admin\SeoClassController@index', ['admin'] ] ],
	['admin/seo_class/{class_id}/{id}' => ['get', 'Admin\SeoClassController@edit', ['admin'] ] ],
	['admin/seo_class/{class_id}/{id}' => ['post', 'Admin\SeoClassController@add', ['admin'] ] ],
	['admin/seo_class/{class_id}/{id}' => ['patch', 'Admin\SeoClassController@upd', ['admin'] ] ],
	['admin/seo_class/{class_id}/{id}' => ['delete', 'Admin\SeoClassController@del', ['admin'] ] ],
	['admin/seo_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\SeoClassController@ajax_upd'] ],
		# 商品
	['admin/seo/{class_id}'      => ['get', 'Admin\SeoController@index', ['admin'] ] ],
	['admin/seo/{class_id}/{id}' => ['get', 'Admin\SeoController@edit', ['admin'] ] ],
	['admin/seo/{class_id}/{id}' => ['post', 'Admin\SeoController@add', ['admin'] ] ],
	['admin/seo/{class_id}/{id}' => ['patch', 'Admin\SeoController@upd', ['admin'] ] ],
	['admin/seo/{class_id}/{id}' => ['delete', 'Admin\SeoController@del', ['admin'] ] ],

	// 會員管理
	['admin/member'                => ['get', 'Admin\MemberController@index', ['admin'] ] ],
	['admin/member/{id}'           => ['get', 'Admin\MemberController@edit', ['admin'] ] ],
	['admin/member/{id}'           => ['post', 'Admin\MemberController@add', ['admin'] ] ],
	['admin/member/{id}'           => ['patch', 'Admin\MemberController@upd', ['admin'] ] ],
	['admin/member/{id}'           => ['delete', 'Admin\MemberController@del', ['admin'] ] ],
	['admin/member/upd_pw/{id}'    => ['get', 'Admin\MemberController@show_upd_pw', ['admin'] ] ],
	['admin/member/upd_pw/{id}'    => ['patch', 'Admin\MemberController@upd_pw', ['admin'] ] ],
	['admin/member/excel/{action}' => ['any', 'Admin\MemberController@excel', ['admin'] ] ],
	['admin/member/ajax/upd/{id}/{column}'  => ['patch', 'Admin\MemberController@ajax_upd', ['admin'] ] ],
	['admin/member/send_level_pass_mail/{id}' => ['get', 'Admin\MemberController@send_level_pass_mail', ['admin'] ] ],

	// 會員 - 公佈欄
		# 分類
	['admin/member/news_class/{class_id}'      => ['get', 'Admin\MemberNewsClassController@index', ['admin'] ] ],
	['admin/member/news_class/{class_id}/{id}' => ['get', 'Admin\MemberNewsClassController@edit', ['admin'] ] ],
	['admin/member/news_class/{class_id}/{id}' => ['post', 'Admin\MemberNewsClassController@add', ['admin'] ] ],
	['admin/member/news_class/{class_id}/{id}' => ['patch', 'Admin\MemberNewsClassController@upd', ['admin'] ] ],
	['admin/member/news_class/{class_id}/{id}' => ['delete', 'Admin\MemberNewsClassController@del', ['admin'] ] ],
	['admin/member/news_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\MemberNewsClassController@ajax_upd'] ],
		# 商品
	['admin/member/news/{class_id}'       => ['get', 'Admin\MemberNewsController@index', ['admin'] ] ],
	['admin/member/news/{class_id}/{id}'  => ['get', 'Admin\MemberNewsController@edit', ['admin'] ] ],
	['admin/member/news/{class_id}/{id}'  => ['post', 'Admin\MemberNewsController@add', ['admin'] ] ],
	['admin/member/news/{class_id}/{id}'  => ['patch', 'Admin\MemberNewsController@upd', ['admin'] ] ],
	['admin/member/news/{class_id}/{id}'  => ['delete', 'Admin\MemberNewsController@del', ['admin'] ] ],
	['admin/member/news/ajax/upd/{id}/{column}' => ['patch', 'Admin\MemberNewsController@ajax_upd'] ],
		# 多檔
	['admin/member/news/ajax/files/{pid}' => ['get', 'Admin\MemberNewsController@ajax_files_get'] ],
	['admin/member/news/ajax/files/{pid}' => ['post', 'Admin\MemberNewsController@ajax_files_upload'] ],
	['admin/member/news/ajax/files/pdf_cover/{id}'   => ['post', 'Admin\MemberNewsController@ajax_files_pdf_cover'] ],
	['admin/member/news/ajax/files/{pid}/{id}/{column}' => ['patch', 'Admin\MemberNewsController@ajax_files_upd'] ],
	['admin/member/news/ajax/files/{pid}/{id}' => ['delete', 'Admin\MemberNewsController@ajax_files_del'] ],

	// 會員 - 下載型錄
		# 分類
	['admin/member/download_class/{class_id}'      => ['get', 'Admin\MemberDownloadClassController@index', ['admin'] ] ],
	['admin/member/download_class/{class_id}/{id}' => ['get', 'Admin\MemberDownloadClassController@edit', ['admin'] ] ],
	['admin/member/download_class/{class_id}/{id}' => ['post', 'Admin\MemberDownloadClassController@add', ['admin'] ] ],
	['admin/member/download_class/{class_id}/{id}' => ['patch', 'Admin\MemberDownloadClassController@upd', ['admin'] ] ],
	['admin/member/download_class/{class_id}/{id}' => ['delete', 'Admin\MemberDownloadClassController@del', ['admin'] ] ],
	['admin/member/download_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\MemberDownloadClassController@ajax_upd'] ],
		# 商品
	['admin/member/download/{class_id}'       => ['get', 'Admin\MemberDownloadController@index', ['admin'] ] ],
	['admin/member/download/{class_id}/{id}'  => ['get', 'Admin\MemberDownloadController@edit', ['admin'] ] ],
	['admin/member/download/{class_id}/{id}'  => ['post', 'Admin\MemberDownloadController@add', ['admin'] ] ],
	['admin/member/download/{class_id}/{id}'  => ['patch', 'Admin\MemberDownloadController@upd', ['admin'] ] ],
	['admin/member/download/{class_id}/{id}'  => ['delete', 'Admin\MemberDownloadController@del', ['admin'] ] ],
	['admin/member/download/ajax/upd/{id}/{column}' => ['patch', 'Admin\MemberDownloadController@ajax_upd'] ],

	// 會員 - 特殊檔案下載
		# 分類
	['admin/member/special_download_class/{class_id}'      => ['get', 'Admin\MemberSpecialDownloadClassController@index', ['admin'] ] ],
	['admin/member/special_download_class/{class_id}/{id}' => ['get', 'Admin\MemberSpecialDownloadClassController@edit', ['admin'] ] ],
	['admin/member/special_download_class/{class_id}/{id}' => ['post', 'Admin\MemberSpecialDownloadClassController@add', ['admin'] ] ],
	['admin/member/special_download_class/{class_id}/{id}' => ['patch', 'Admin\MemberSpecialDownloadClassController@upd', ['admin'] ] ],
	['admin/member/special_download_class/{class_id}/{id}' => ['delete', 'Admin\MemberSpecialDownloadClassController@del', ['admin'] ] ],
	['admin/member/special_download_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\MemberSpecialDownloadClassController@ajax_upd'] ],
		# 商品
	['admin/member/special_download/{class_id}'       => ['get', 'Admin\MemberSpecialDownloadController@index', ['admin'] ] ],
	['admin/member/special_download/{class_id}/{id}'  => ['get', 'Admin\MemberSpecialDownloadController@edit', ['admin'] ] ],
	['admin/member/special_download/{class_id}/{id}'  => ['post', 'Admin\MemberSpecialDownloadController@add', ['admin'] ] ],
	['admin/member/special_download/{class_id}/{id}'  => ['patch', 'Admin\MemberSpecialDownloadController@upd', ['admin'] ] ],
	['admin/member/special_download/{class_id}/{id}'  => ['delete', 'Admin\MemberSpecialDownloadController@del', ['admin'] ] ],
	['admin/member/special_download/ajax/upd/{id}/{column}' => ['patch', 'Admin\MemberSpecialDownloadController@ajax_upd'] ],

	// 修改 : 新增 即時報價 - 表單管理
	['admin/quote'                        => ['get', 'Admin\QuoteController@index', ['admin'] ] ],
	['admin/quote/{id}'                   => ['get', 'Admin\QuoteController@edit', ['admin'] ] ],
	['admin/quote/{id}'                   => ['patch', 'Admin\QuoteController@upd', ['admin'] ] ],
	['admin/quote/{id}'                   => ['delete', 'Admin\QuoteController@del', ['admin'] ] ],
	['admin/quote/detail/{oid}'           => ['get', 'Admin\QuoteController@detail', ['admin'] ] ],
	['admin/quote/excel/{action}'         => ['any', 'Admin\QuoteController@excel', ['admin'] ] ],
	['admin/quote/ajax/upd/{id}/{column}' => ['patch', 'Admin\QuoteController@ajax_upd'] ],

	// 修改 : 新增 預約鑑賞 - 表單管理
	['admin/reserve'                        => ['get', 'Admin\ReserveController@index', ['admin'] ] ],
	['admin/reserve/{id}'                   => ['get', 'Admin\ReserveController@edit', ['admin'] ] ],
	['admin/reserve/{id}'                   => ['patch', 'Admin\ReserveController@upd', ['admin'] ] ],
	['admin/reserve/{id}'                   => ['delete', 'Admin\ReserveController@del', ['admin'] ] ],
	['admin/reserve/detail/{oid}'           => ['get', 'Admin\ReserveController@detail', ['admin'] ] ],
	['admin/reserve/excel/{action}'         => ['any', 'Admin\ReserveController@excel', ['admin'] ] ],
	['admin/reserve/ajax/upd/{id}/{column}' => ['patch', 'Admin\ReserveController@ajax_upd'] ],

	// 修改 : 新增 虛擬展間(舊)
	// ['admin/room/scene'        => ['get', 'Admin\RoomController@scene', ['admin'] ] ],
	// ['admin/room/series'       => ['get', 'Admin\RoomController@series', ['admin'] ] ],
	// ['admin/room/merch'        => ['get', 'Admin\RoomController@merch', ['admin'] ] ],
	// ['admin/room/sample'       => ['get', 'Admin\RoomController@sample', ['admin'] ] ],
	// ['admin/room/infrared'     => ['get', 'Admin\RoomController@infrared', ['admin'] ] ],
	// ['admin/room/construction'      => ['get', 'Admin\RoomController@construction', ['admin'] ] ],
	// ['admin/room/construction/{id}' => ['patch', 'Admin\RoomController@upd', ['admin'] ] ],
	// ['admin/room/watermark'    => ['get', 'Admin\RoomController@watermark', ['admin'] ] ],


	// 修改 : 新增 虛擬展間
	['admin/room'      => ['get', 'Admin\RoomController@index', ['admin'] ] ],
	['admin/room/{id}' => ['get', 'Admin\RoomController@edit', ['admin'] ] ],
	['admin/room/{id}' => ['post', 'Admin\RoomController@add', ['admin'] ] ],
	['admin/room/{id}' => ['patch', 'Admin\RoomController@upd', ['admin'] ] ],
	['admin/room/{id}' => ['delete', 'Admin\RoomController@del', ['admin'] ] ],
	
	# 多圖
	['admin/room/ajax/pics/{pid}'               => ['get', 'Admin\RoomController@ajax_pics_get'] ],
	['admin/room/ajax/pics/{pid}'               => ['post', 'Admin\RoomController@ajax_pics_upload'] ],
	['admin/room/ajax/pics/{pid}/{id}/{column}' => ['patch', 'Admin\RoomController@ajax_pics_upd'] ],
	['admin/room/ajax/pics/{pid}/{id}'          => ['delete', 'Admin\RoomController@ajax_pics_del'] ],
	
	# 多檔
	['admin/room/ajax/files/{pid}'               => ['get', 'Admin\RoomController@ajax_files_get'] ],
	['admin/room/ajax/files/{pid}'               => ['post', 'Admin\RoomController@ajax_files_upload'] ],
	['admin/room/ajax/files/{pid}/{id}/{column}' => ['patch', 'Admin\RoomController@ajax_files_upd'] ],
	['admin/room/ajax/files/{pid}/{id}'          => ['delete', 'Admin\RoomController@ajax_files_del'] ],


	// 訂單管理
	['admin/order'                => ['get', 'Admin\OrderController@index', ['admin'] ] ],
	['admin/order/{id}'           => ['get', 'Admin\OrderController@edit', ['admin'] ] ],
	// ['admin/order/{id}'        => ['post', 'Admin\OrderController@add', ['admin'] ] ],
	['admin/order/{id}'           => ['patch', 'Admin\OrderController@upd', ['admin'] ] ],
	['admin/order/{id}'           => ['delete', 'Admin\OrderController@del', ['admin'] ] ],
	['admin/order/detail/{oid}'   => ['get', 'Admin\OrderController@detail', ['admin'] ] ],
	['admin/order/excel/{action}' => ['any', 'Admin\OrderController@excel', ['admin'] ] ],
	['admin/order/ajax/upd/{id}/{column}' => ['patch', 'Admin\OrderController@ajax_upd'] ],
		# 配送管理
	['admin/order/delivery'      => ['get', 'Admin\OrderDeliveryController@index', ['admin'] ] ],
	['admin/order/delivery/{id}' => ['get', 'Admin\OrderDeliveryController@edit', ['admin'] ] ],
	// ['admin/order/delivery/{id}' => ['post', 'Admin\OrderDeliveryController@add', ['admin'] ] ],
	['admin/order/delivery/{id}' => ['patch', 'Admin\OrderDeliveryController@upd', ['admin'] ] ],
	['admin/order/delivery/{id}' => ['delete', 'Admin\OrderDeliveryController@del', ['admin'] ] ],
		# 付款管理
	['admin/order/pay'      => ['get', 'Admin\OrderPayController@index', ['admin'] ] ],
	['admin/order/pay/{id}' => ['get', 'Admin\OrderPayController@edit', ['admin'] ] ],
	// ['admin/order/pay/{id}' => ['post', 'Admin\OrderPayController@add', ['admin'] ] ],
	['admin/order/pay/{id}' => ['patch', 'Admin\OrderPayController@upd', ['admin'] ] ],
	['admin/order/pay/{id}' => ['delete', 'Admin\OrderPayController@del', ['admin'] ] ],

	// Banner
	['admin/banner'      => ['get', 'Admin\BannerController@index', ['admin'] ] ],
	['admin/banner/{id}' => ['get', 'Admin\BannerController@edit', ['admin'] ] ],
	['admin/banner/{id}' => ['post', 'Admin\BannerController@add', ['admin'] ] ],
	['admin/banner/{id}' => ['patch', 'Admin\BannerController@upd', ['admin'] ] ],
	['admin/banner/{id}' => ['delete', 'Admin\BannerController@del', ['admin'] ] ],
	['admin/banner/ajax/upd/{id}/{column}' => ['patch', 'Admin\BannerController@ajax_upd'] ],

	// 系列產品展示區
	['admin/home_product'      => ['get', 'Admin\HomeProductController@index', ['admin'] ] ],
	['admin/home_product/{id}' => ['get', 'Admin\HomeProductController@edit', ['admin'] ] ],
	['admin/home_product/{id}' => ['post', 'Admin\HomeProductController@add', ['admin'] ] ],
	['admin/home_product/{id}' => ['patch', 'Admin\HomeProductController@upd', ['admin'] ] ],
	['admin/home_product/{id}' => ['delete', 'Admin\HomeProductController@del', ['admin'] ] ],
	['admin/home_product/ajax/upd/{id}/{column}' => ['patch', 'Admin\HomeProductController@ajax_upd'] ],

	// 頁尾 - 產品介紹
	['admin/footer_product'      => ['get', 'Admin\FooterProductController@index', ['admin'] ] ],
	['admin/footer_product/{id}' => ['get', 'Admin\FooterProductController@edit', ['admin'] ] ],
	['admin/footer_product/{id}' => ['post', 'Admin\FooterProductController@add', ['admin'] ] ],
	['admin/footer_product/{id}' => ['patch', 'Admin\FooterProductController@upd', ['admin'] ] ],
	['admin/footer_product/{id}' => ['delete', 'Admin\FooterProductController@del', ['admin'] ] ],
	['admin/footer_product/ajax/upd/{id}/{column}' => ['patch', 'Admin\FooterProductController@ajax_upd'] ],

	// 公司介紹
		# 分類
	['admin/about_class/{class_id}'      => ['get', 'Admin\AboutClassController@index', ['admin'] ] ],
	['admin/about_class/{class_id}/{id}' => ['get', 'Admin\AboutClassController@edit', ['admin'] ] ],
	['admin/about_class/{class_id}/{id}' => ['post', 'Admin\AboutClassController@add', ['admin'] ] ],
	['admin/about_class/{class_id}/{id}' => ['patch', 'Admin\AboutClassController@upd', ['admin'] ] ],
	['admin/about_class/{class_id}/{id}' => ['delete', 'Admin\AboutClassController@del', ['admin'] ] ],
	['admin/about_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\AboutClassController@ajax_upd'] ],
		# 商品
	['admin/about/{class_id}'       => ['get', 'Admin\AboutController@index', ['admin'] ] ],
	['admin/about/{class_id}/{id}'  => ['get', 'Admin\AboutController@edit', ['admin'] ] ],
	['admin/about/{class_id}/{id}'  => ['post', 'Admin\AboutController@add', ['admin'] ] ],
	['admin/about/{class_id}/{id}'  => ['patch', 'Admin\AboutController@upd', ['admin'] ] ],
	['admin/about/{class_id}/{id}'  => ['delete', 'Admin\AboutController@del', ['admin'] ] ],
	['admin/about/ajax/upd/{id}/{column}' => ['patch', 'Admin\AboutController@ajax_upd'] ],
		# 多檔
	['admin/about/ajax/files/{pid}' => ['get', 'Admin\AboutController@ajax_files_get'] ],
	['admin/about/ajax/files/{pid}' => ['post', 'Admin\AboutController@ajax_files_upload'] ],
	['admin/about/ajax/files/pdf_cover/{id}'   => ['post', 'Admin\AboutController@ajax_files_pdf_cover'] ],
	['admin/about/ajax/files/{pid}/{id}/{column}' => ['patch', 'Admin\AboutController@ajax_files_upd'] ],
	['admin/about/ajax/files/{pid}/{id}' => ['delete', 'Admin\AboutController@ajax_files_del'] ],

	// 健康能量木地板
		# 分類
	['admin/floors_class/{class_id}'      => ['get', 'Admin\FloorsClassController@index', ['admin'] ] ],
	['admin/floors_class/{class_id}/{id}' => ['get', 'Admin\FloorsClassController@edit', ['admin'] ] ],
	['admin/floors_class/{class_id}/{id}' => ['post', 'Admin\FloorsClassController@add', ['admin'] ] ],
	['admin/floors_class/{class_id}/{id}' => ['patch', 'Admin\FloorsClassController@upd', ['admin'] ] ],
	['admin/floors_class/{class_id}/{id}' => ['delete', 'Admin\FloorsClassController@del', ['admin'] ] ],
	['admin/floors_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\FloorsClassController@ajax_upd'] ],
		# 商品
	['admin/floors/{class_id}'       => ['get', 'Admin\FloorsController@index', ['admin'] ] ],
	['admin/floors/{class_id}/{id}'  => ['get', 'Admin\FloorsController@edit', ['admin'] ] ],
	['admin/floors/{class_id}/{id}'  => ['post', 'Admin\FloorsController@add', ['admin'] ] ],
	['admin/floors/{class_id}/{id}'  => ['patch', 'Admin\FloorsController@upd', ['admin'] ] ],
	['admin/floors/{class_id}/{id}'  => ['delete', 'Admin\FloorsController@del', ['admin'] ] ],
	['admin/floors/ajax/upd/{id}/{column}' => ['patch', 'Admin\FloorsController@ajax_upd'] ],
		# 多檔
	['admin/floors/ajax/files/{pid}' => ['get', 'Admin\FloorsController@ajax_files_get'] ],
	['admin/floors/ajax/files/{pid}' => ['post', 'Admin\FloorsController@ajax_files_upload'] ],
	['admin/floors/ajax/files/pdf_cover/{id}'   => ['post', 'Admin\FloorsController@ajax_files_pdf_cover'] ],
	['admin/floors/ajax/files/{pid}/{id}/{column}' => ['patch', 'Admin\FloorsController@ajax_files_upd'] ],
	['admin/floors/ajax/files/{pid}/{id}' => ['delete', 'Admin\FloorsController@ajax_files_del'] ],

	// 產品介紹
		# 分類
	['admin/product_class/{class_id}'      => ['get', 'Admin\ProductClassController@index', ['admin'] ] ],
	['admin/product_class/{class_id}/{id}' => ['get', 'Admin\ProductClassController@edit', ['admin'] ] ],
	['admin/product_class/{class_id}/{id}' => ['post', 'Admin\ProductClassController@add', ['admin'] ] ],
	['admin/product_class/{class_id}/{id}' => ['patch', 'Admin\ProductClassController@upd', ['admin'] ] ],
	['admin/product_class/{class_id}/{id}' => ['delete', 'Admin\ProductClassController@del', ['admin'] ] ],
	['admin/product_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\ProductClassController@ajax_upd'] ],
		# 商品
	['admin/product/{class_id}'       => ['get', 'Admin\ProductController@index', ['admin'] ] ],
	['admin/product/{class_id}/{id}'  => ['get', 'Admin\ProductController@edit', ['admin'] ] ],
	['admin/product/{class_id}/{id}'  => ['post', 'Admin\ProductController@add', ['admin'] ] ],
	['admin/product/{class_id}/{id}'  => ['patch', 'Admin\ProductController@upd', ['admin'] ] ],
	['admin/product/{class_id}/{id}'  => ['delete', 'Admin\ProductController@del', ['admin'] ] ],
	['admin/product/ajax/upd/{id}/{column}' => ['patch', 'Admin\ProductController@ajax_upd'] ],
		# 多圖
	['admin/product/ajax/pics/{pid}' => ['get', 'Admin\ProductController@ajax_pics_get'] ],
	['admin/product/ajax/pics/{pid}' => ['post', 'Admin\ProductController@ajax_pics_upload'] ],
	['admin/product/ajax/pics/{pid}/{id}/{column}' => ['patch', 'Admin\ProductController@ajax_pics_upd'] ],
	['admin/product/ajax/pics/{pid}/{id}' => ['delete', 'Admin\ProductController@ajax_pics_del'] ],
		# 庫存
	['admin/product/ajax/stock/{pid}'      => ['get', 'Admin\ProductController@ajax_stock_get'] ],
	['admin/product/ajax/stock/{pid}/{id}' => ['patch', 'Admin\ProductController@ajax_stock_upd'] ],	
		# 屬性關聯
	['admin/product/ajax/relate_by_attribute/{pid}'      => ['get', 'Admin\ProductController@ajax_relate_by_attribute_get'] ],
	['admin/product/ajax/relate_by_attribute/{pid}'      => ['post', 'Admin\ProductController@ajax_relate_by_attribute_add'] ],
	['admin/product/ajax/relate_by_attribute/{pid}/{id}' => ['delete', 'Admin\ProductController@ajax_relate_by_attribute_del'] ],
	['admin/product/ajax/relate_by_attribute/search'     => ['get', 'Admin\ProductController@ajax_relate_by_attribute_search'] ],
		# 專案實績關聯
	['admin/product/ajax/relate_by_case/{pid}'      => ['get', 'Admin\ProductController@ajax_relate_by_case_get'] ],
	['admin/product/ajax/relate_by_case/{pid}'      => ['post', 'Admin\ProductController@ajax_relate_by_case_add'] ],
	['admin/product/ajax/relate_by_case/{pid}/{id}' => ['delete', 'Admin\ProductController@ajax_relate_by_case_del'] ],
	['admin/product/ajax/relate_by_case/search'     => ['get', 'Admin\ProductController@ajax_relate_by_case_search'] ],
		# 產品關聯
	['admin/product/ajax/relate_by_product/{pid}'      => ['get', 'Admin\ProductController@ajax_relate_by_product_get'] ],
	['admin/product/ajax/relate_by_product/{pid}'      => ['post', 'Admin\ProductController@ajax_relate_by_product_add'] ],
	['admin/product/ajax/relate_by_product/{pid}/{id}' => ['delete', 'Admin\ProductController@ajax_relate_by_product_del'] ],
	['admin/product/ajax/relate_by_product/search'     => ['get', 'Admin\ProductController@ajax_relate_by_product_search'] ],
		# 產品認證關聯
	['admin/product/ajax/relate_by_service_download/{pid}'      => ['get', 'Admin\ProductController@ajax_relate_by_service_download_get'] ],
	['admin/product/ajax/relate_by_service_download/{pid}'      => ['post', 'Admin\ProductController@ajax_relate_by_service_download_add'] ],
	['admin/product/ajax/relate_by_service_download/{pid}/{id}' => ['delete', 'Admin\ProductController@ajax_relate_by_service_download_del'] ],
	['admin/product/ajax/relate_by_service_download/search'     => ['get', 'Admin\ProductController@ajax_relate_by_service_download_search'] ],

	// 產品屬性
		# 分類
	['admin/product_attribute_class/{class_id}'      => ['get', 'Admin\ProductAttributeClassController@index', ['admin'] ] ],
	['admin/product_attribute_class/{class_id}/{id}' => ['get', 'Admin\ProductAttributeClassController@edit', ['admin'] ] ],
	['admin/product_attribute_class/{class_id}/{id}' => ['post', 'Admin\ProductAttributeClassController@add', ['admin'] ] ],
	['admin/product_attribute_class/{class_id}/{id}' => ['patch', 'Admin\ProductAttributeClassController@upd', ['admin'] ] ],
	['admin/product_attribute_class/{class_id}/{id}' => ['delete', 'Admin\ProductAttributeClassController@del', ['admin'] ] ],
	['admin/product_attribute_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\ProductAttributeClassController@ajax_upd'] ],
		# 商品
	['admin/product_attribute/{class_id}'       => ['get', 'Admin\ProductAttributeController@index', ['admin'] ] ],
	['admin/product_attribute/{class_id}/{id}'  => ['get', 'Admin\ProductAttributeController@edit', ['admin'] ] ],
	['admin/product_attribute/{class_id}/{id}'  => ['post', 'Admin\ProductAttributeController@add', ['admin'] ] ],
	['admin/product_attribute/{class_id}/{id}'  => ['patch', 'Admin\ProductAttributeController@upd', ['admin'] ] ],
	['admin/product_attribute/{class_id}/{id}'  => ['delete', 'Admin\ProductAttributeController@del', ['admin'] ] ],
	['admin/product_attribute/ajax/upd/{id}/{column}' => ['patch', 'Admin\ProductAttributeController@ajax_upd'] ],

	// 專案實績
		# 分類
	['admin/case_class/{class_id}'      => ['get', 'Admin\CaseClassController@index', ['admin'] ] ],
	['admin/case_class/{class_id}/{id}' => ['get', 'Admin\CaseClassController@edit', ['admin'] ] ],
	['admin/case_class/{class_id}/{id}' => ['post', 'Admin\CaseClassController@add', ['admin'] ] ],
	['admin/case_class/{class_id}/{id}' => ['patch', 'Admin\CaseClassController@upd', ['admin'] ] ],
	['admin/case_class/{class_id}/{id}' => ['delete', 'Admin\CaseClassController@del', ['admin'] ] ],
	['admin/case_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\CaseClassController@ajax_upd'] ],
		# 商品
	['admin/case/{class_id}'       => ['get', 'Admin\CaseController@index', ['admin'] ] ],
	['admin/case/{class_id}/{id}'  => ['get', 'Admin\CaseController@edit', ['admin'] ] ],
	['admin/case/{class_id}/{id}'  => ['post', 'Admin\CaseController@add', ['admin'] ] ],
	['admin/case/{class_id}/{id}'  => ['patch', 'Admin\CaseController@upd', ['admin'] ] ],
	['admin/case/{class_id}/{id}'  => ['delete', 'Admin\CaseController@del', ['admin'] ] ],
	['admin/case/ajax/upd/{id}/{column}' => ['patch', 'Admin\CaseController@ajax_upd'] ],
		# 多圖
	['admin/case/ajax/pics/{pid}' => ['get', 'Admin\CaseController@ajax_pics_get'] ],
	['admin/case/ajax/pics/{pid}' => ['post', 'Admin\CaseController@ajax_pics_upload'] ],
	['admin/case/ajax/pics/{pid}/{id}/{column}' => ['patch', 'Admin\CaseController@ajax_pics_upd'] ],
	['admin/case/ajax/pics/{pid}/{id}' => ['delete', 'Admin\CaseController@ajax_pics_del'] ],
		# 屬性關聯
	['admin/case/ajax/relate_by_attribute/{pid}'      => ['get', 'Admin\CaseController@ajax_relate_by_attribute_get'] ],
	['admin/case/ajax/relate_by_attribute/{pid}'      => ['post', 'Admin\CaseController@ajax_relate_by_attribute_add'] ],
	['admin/case/ajax/relate_by_attribute/{pid}/{id}' => ['delete', 'Admin\CaseController@ajax_relate_by_attribute_del'] ],
	['admin/case/ajax/relate_by_attribute/search'     => ['get', 'Admin\CaseController@ajax_relate_by_attribute_search'] ],
		# 產品關聯
	['admin/case/ajax/relate_by_product/{pid}'      => ['get', 'Admin\CaseController@ajax_relate_by_product_get'] ],
	['admin/case/ajax/relate_by_product/{pid}'      => ['post', 'Admin\CaseController@ajax_relate_by_product_add'] ],
	['admin/case/ajax/relate_by_product/{pid}/{id}' => ['delete', 'Admin\CaseController@ajax_relate_by_product_del'] ],
	['admin/case/ajax/relate_by_product/search'     => ['get', 'Admin\CaseController@ajax_relate_by_product_search'] ],
		# 產品關聯 - 管理
	['admin/case/relate_by_product/manager/{id}' => ['get', 'Admin\CaseRelateByProductController@show_manager'] ],
	['admin/case/relate_by_product/{id}'         => ['patch', 'Admin\CaseRelateByProductController@upd', ['admin'] ] ],

	// 專案實績屬性
		# 分類
	['admin/case_attribute_class/{class_id}'      => ['get', 'Admin\CaseAttributeClassController@index', ['admin'] ] ],
	['admin/case_attribute_class/{class_id}/{id}' => ['get', 'Admin\CaseAttributeClassController@edit', ['admin'] ] ],
	['admin/case_attribute_class/{class_id}/{id}' => ['post', 'Admin\CaseAttributeClassController@add', ['admin'] ] ],
	['admin/case_attribute_class/{class_id}/{id}' => ['patch', 'Admin\CaseAttributeClassController@upd', ['admin'] ] ],
	['admin/case_attribute_class/{class_id}/{id}' => ['delete', 'Admin\CaseAttributeClassController@del', ['admin'] ] ],
	['admin/case_attribute_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\CaseAttributeClassController@ajax_upd'] ],
		# 商品
	['admin/case_attribute/{class_id}'       => ['get', 'Admin\CaseAttributeController@index', ['admin'] ] ],
	['admin/case_attribute/{class_id}/{id}'  => ['get', 'Admin\CaseAttributeController@edit', ['admin'] ] ],
	['admin/case_attribute/{class_id}/{id}'  => ['post', 'Admin\CaseAttributeController@add', ['admin'] ] ],
	['admin/case_attribute/{class_id}/{id}'  => ['patch', 'Admin\CaseAttributeController@upd', ['admin'] ] ],
	['admin/case_attribute/{class_id}/{id}'  => ['delete', 'Admin\CaseAttributeController@del', ['admin'] ] ],
	['admin/case_attribute/ajax/upd/{id}/{column}' => ['patch', 'Admin\CaseAttributeController@ajax_upd'] ],

	// 影音訊息
		# 分類
	['admin/video_class/{class_id}'      => ['get', 'Admin\VideoClassController@index', ['admin'] ] ],
	['admin/video_class/{class_id}/{id}' => ['get', 'Admin\VideoClassController@edit', ['admin'] ] ],
	['admin/video_class/{class_id}/{id}' => ['post', 'Admin\VideoClassController@add', ['admin'] ] ],
	['admin/video_class/{class_id}/{id}' => ['patch', 'Admin\VideoClassController@upd', ['admin'] ] ],
	['admin/video_class/{class_id}/{id}' => ['delete', 'Admin\VideoClassController@del', ['admin'] ] ],
	['admin/video_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\VideoClassController@ajax_upd'] ],
		# 商品
	['admin/video/{class_id}'       => ['get', 'Admin\VideoController@index', ['admin'] ] ],
	['admin/video/{class_id}/{id}'  => ['get', 'Admin\VideoController@edit', ['admin'] ] ],
	['admin/video/{class_id}/{id}'  => ['post', 'Admin\VideoController@add', ['admin'] ] ],
	['admin/video/{class_id}/{id}'  => ['patch', 'Admin\VideoController@upd', ['admin'] ] ],
	['admin/video/{class_id}/{id}'  => ['delete', 'Admin\VideoController@del', ['admin'] ] ],
	['admin/video/ajax/upd/{id}/{column}' => ['patch', 'Admin\VideoController@ajax_upd'] ],

	// 客戶服務 - 門市據點
		# 分類
	['admin/service_store_class/{class_id}'      => ['get', 'Admin\ServiceStoreClassController@index', ['admin'] ] ],
	['admin/service_store_class/{class_id}/{id}' => ['get', 'Admin\ServiceStoreClassController@edit', ['admin'] ] ],
	['admin/service_store_class/{class_id}/{id}' => ['post', 'Admin\ServiceStoreClassController@add', ['admin'] ] ],
	['admin/service_store_class/{class_id}/{id}' => ['patch', 'Admin\ServiceStoreClassController@upd', ['admin'] ] ],
	['admin/service_store_class/{class_id}/{id}' => ['delete', 'Admin\ServiceStoreClassController@del', ['admin'] ] ],
	['admin/service_store_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\ServiceStoreClassController@ajax_upd'] ],
		# 商品
	['admin/service_store/{class_id}'       => ['get', 'Admin\ServiceStoreController@index', ['admin'] ] ],
	['admin/service_store/{class_id}/{id}'  => ['get', 'Admin\ServiceStoreController@edit', ['admin'] ] ],
	['admin/service_store/{class_id}/{id}'  => ['post', 'Admin\ServiceStoreController@add', ['admin'] ] ],
	['admin/service_store/{class_id}/{id}'  => ['patch', 'Admin\ServiceStoreController@upd', ['admin'] ] ],
	['admin/service_store/{class_id}/{id}'  => ['delete', 'Admin\ServiceStoreController@del', ['admin'] ] ],
	['admin/service_store/ajax/upd/{id}/{column}' => ['patch', 'Admin\ServiceStoreController@ajax_upd'] ],

	// 客戶服務 - 檔案下載
		# 分類
	['admin/service_download_class/{class_id}'      => ['get', 'Admin\ServiceDownloadClassController@index', ['admin'] ] ],
	['admin/service_download_class/{class_id}/{id}' => ['get', 'Admin\ServiceDownloadClassController@edit', ['admin'] ] ],
	['admin/service_download_class/{class_id}/{id}' => ['post', 'Admin\ServiceDownloadClassController@add', ['admin'] ] ],
	['admin/service_download_class/{class_id}/{id}' => ['patch', 'Admin\ServiceDownloadClassController@upd', ['admin'] ] ],
	['admin/service_download_class/{class_id}/{id}' => ['delete', 'Admin\ServiceDownloadClassController@del', ['admin'] ] ],
	['admin/service_download_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\ServiceDownloadClassController@ajax_upd'] ],
		# 商品
	['admin/service_download/{class_id}'       => ['get', 'Admin\ServiceDownloadController@index', ['admin'] ] ],
	['admin/service_download/{class_id}/{id}'  => ['get', 'Admin\ServiceDownloadController@edit', ['admin'] ] ],
	['admin/service_download/{class_id}/{id}'  => ['post', 'Admin\ServiceDownloadController@add', ['admin'] ] ],
	['admin/service_download/{class_id}/{id}'  => ['patch', 'Admin\ServiceDownloadController@upd', ['admin'] ] ],
	['admin/service_download/{class_id}/{id}'  => ['delete', 'Admin\ServiceDownloadController@del', ['admin'] ] ],
	['admin/service_download/ajax/upd/{id}/{column}' => ['patch', 'Admin\ServiceDownloadController@ajax_upd'] ],

	// 木學堂百科 - 常見問題
		# 分類
	['admin/library_faq_class/{class_id}'      => ['get', 'Admin\LibraryFaqClassController@index', ['admin'] ] ],
	['admin/library_faq_class/{class_id}/{id}' => ['get', 'Admin\LibraryFaqClassController@edit', ['admin'] ] ],
	['admin/library_faq_class/{class_id}/{id}' => ['post', 'Admin\LibraryFaqClassController@add', ['admin'] ] ],
	['admin/library_faq_class/{class_id}/{id}' => ['patch', 'Admin\LibraryFaqClassController@upd', ['admin'] ] ],
	['admin/library_faq_class/{class_id}/{id}' => ['delete', 'Admin\LibraryFaqClassController@del', ['admin'] ] ],
	['admin/library_faq_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\LibraryFaqClassController@ajax_upd'] ],
		# 商品
	['admin/library_faq/{class_id}'       => ['get', 'Admin\LibraryFaqController@index', ['admin'] ] ],
	['admin/library_faq/{class_id}/{id}'  => ['get', 'Admin\LibraryFaqController@edit', ['admin'] ] ],
	['admin/library_faq/{class_id}/{id}'  => ['post', 'Admin\LibraryFaqController@add', ['admin'] ] ],
	['admin/library_faq/{class_id}/{id}'  => ['patch', 'Admin\LibraryFaqController@upd', ['admin'] ] ],
	['admin/library_faq/{class_id}/{id}'  => ['delete', 'Admin\LibraryFaqController@del', ['admin'] ] ],
	['admin/library_faq/ajax/upd/{id}/{column}' => ['patch', 'Admin\LibraryFaqController@ajax_upd'] ],

	// 木學堂百科 - 百科文章
		# 分類
	['admin/library_article_class/{class_id}'      => ['get', 'Admin\LibraryArticleClassController@index', ['admin'] ] ],
	['admin/library_article_class/{class_id}/{id}' => ['get', 'Admin\LibraryArticleClassController@edit', ['admin'] ] ],
	['admin/library_article_class/{class_id}/{id}' => ['post', 'Admin\LibraryArticleClassController@add', ['admin'] ] ],
	['admin/library_article_class/{class_id}/{id}' => ['patch', 'Admin\LibraryArticleClassController@upd', ['admin'] ] ],
	['admin/library_article_class/{class_id}/{id}' => ['delete', 'Admin\LibraryArticleClassController@del', ['admin'] ] ],
	['admin/library_article_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\LibraryArticleClassController@ajax_upd'] ],
		# 商品
	['admin/library_article/{class_id}'       => ['get', 'Admin\LibraryArticleController@index', ['admin'] ] ],
	['admin/library_article/{class_id}/{id}'  => ['get', 'Admin\LibraryArticleController@edit', ['admin'] ] ],
	['admin/library_article/{class_id}/{id}'  => ['post', 'Admin\LibraryArticleController@add', ['admin'] ] ],
	['admin/library_article/{class_id}/{id}'  => ['patch', 'Admin\LibraryArticleController@upd', ['admin'] ] ],
	['admin/library_article/{class_id}/{id}'  => ['delete', 'Admin\LibraryArticleController@del', ['admin'] ] ],
	['admin/library_article/ajax/upd/{id}/{column}' => ['patch', 'Admin\LibraryArticleController@ajax_upd'] ],
		# 多檔
	['admin/library_article/ajax/files/{pid}' => ['get', 'Admin\LibraryArticleController@ajax_files_get'] ],
	['admin/library_article/ajax/files/{pid}' => ['post', 'Admin\LibraryArticleController@ajax_files_upload'] ],
	['admin/library_article/ajax/files/pdf_cover/{id}'   => ['post', 'Admin\LibraryArticleController@ajax_files_pdf_cover'] ],
	['admin/library_article/ajax/files/{pid}/{id}/{column}' => ['patch', 'Admin\LibraryArticleController@ajax_files_upd'] ],
	['admin/library_article/ajax/files/{pid}/{id}' => ['delete', 'Admin\LibraryArticleController@ajax_files_del'] ],
		# 產品關聯
	['admin/library_article/ajax/relate/{pid}'      => ['get', 'Admin\LibraryArticleController@ajax_relate_get'] ],
	['admin/library_article/ajax/relate/{pid}'      => ['post', 'Admin\LibraryArticleController@ajax_relate_add'] ],
	['admin/library_article/ajax/relate/{pid}/{id}' => ['delete', 'Admin\LibraryArticleController@ajax_relate_del'] ],
	['admin/library_article/ajax/relate/search'     => ['get', 'Admin\LibraryArticleController@ajax_relate_search'] ],

	// 客戶服務 - 聯絡我們
	['admin/service_contact'      => ['get', 'Admin\ServiceContactController@index', ['admin'] ] ],
	['admin/service_contact/{id}' => ['get', 'Admin\ServiceContactController@edit', ['admin'] ] ],
	// ['admin/service_contact/{id}' => ['post', 'Admin\ServiceContactController@add', ['admin'] ] ],
	['admin/service_contact/{id}' => ['patch', 'Admin\ServiceContactController@upd', ['admin'] ] ],
	['admin/service_contact/{id}' => ['delete', 'Admin\ServiceContactController@del', ['admin'] ] ],
	['admin/service_contact/excel/{action}' => ['get', 'Admin\ServiceContactController@excel', ['admin'] ] ],

	// 套色場景
	
		# 分類
	['admin/theme_class/{class_id}'      => ['get', 'Admin\ThemeClassController@index', ['admin'] ] ],
	['admin/theme_class/{class_id}/{id}' => ['get', 'Admin\ThemeClassController@edit', ['admin'] ] ],
	['admin/theme_class/{class_id}/{id}' => ['post', 'Admin\ThemeClassController@add', ['admin'] ] ],
	['admin/theme_class/{class_id}/{id}' => ['patch', 'Admin\ThemeClassController@upd', ['admin'] ] ],
	['admin/theme_class/{class_id}/{id}' => ['delete', 'Admin\ThemeClassController@del', ['admin'] ] ],
	['admin/theme_class/ajax/upd/{id}/{column}' => ['patch', 'Admin\ThemeClassController@ajax_upd'] ],
	['admin/theme_class/{class_id}/{id}/copy' => ['post', 'Admin\ThemeClassController@copy', ['admin'] ] ],

		# 商品
	['admin/theme/{class_id}'       => ['get', 'Admin\ThemeController@index', ['admin'] ] ],
	['admin/theme/{class_id}/{id}'  => ['get', 'Admin\ThemeController@edit', ['admin'] ] ],
	['admin/theme/{class_id}/{id}'  => ['post', 'Admin\ThemeController@add', ['admin'] ] ],
	['admin/theme/{class_id}/{id}'  => ['patch', 'Admin\ThemeController@upd', ['admin'] ] ],
	['admin/theme/{class_id}/{id}'  => ['delete', 'Admin\ThemeController@del', ['admin'] ] ],
	['admin/theme/ajax/upd/{id}/{column}' => ['patch', 'Admin\ThemeController@ajax_upd'] ],
	['admin/theme/{class_id}/{id}/copy'  => ['post', 'Admin\ThemeController@copy', ['admin'] ] ],

		# 物件
	// ['admin/theme'      => ['get', 'Admin\ThemeController@index', ['admin'] ] ],
	// ['admin/theme/{id}'  => ['get', 'Admin\ThemeController@edit', ['admin'] ] ],
	// ['admin/theme/{id}'  => ['post', 'Admin\ThemeController@add', ['admin'] ] ],
	// ['admin/theme/{id}'  => ['patch', 'Admin\ThemeController@upd', ['admin'] ] ],
	// ['admin/theme/{id}'  => ['delete', 'Admin\ThemeController@del', ['admin'] ] ],

	// ['admin/theme/ajax/upd/{id}/{column}' => ['patch', 'Admin\ThemeController@ajax_upd'] ],
		
];